document.addEventListener("DOMContentLoaded", () => {
  document.querySelector(".header .hamburger").addEventListener("click", () => {
    document.querySelector(".header#masthead").classList.toggle("active");
  });

  const hostName = document.location.hostname;
  const allAddedFetch = [];

  const addFetch = (element) => {
    if (!allAddedFetch.includes(element.getAttribute("href"))) {
      const fetch = document.createElement("link");
      fetch.setAttribute("rel", "prefetch");
      fetch.setAttribute("href", element.getAttribute("href"));

      document.head.append(fetch);

      allAddedFetch.push(element.getAttribute("href"));
    }
  };

  document.querySelectorAll(`.navigation a[href*="${hostName}"], .footer__menu a[href*="${hostName}"]`).forEach(addFetch);

  document.querySelectorAll(`.site-content a[href*="${hostName}"]`).forEach((element) => {
    element.addEventListener("mouseenter", (event) => addFetch(event.target), false);
  });

  document.querySelectorAll(`.single .entry-content a[href*="${hostName}"]`).forEach((element) => {
    window.addEventListener("scroll", () => {
      const distanceFromElement = element.getBoundingClientRect().top - window.screen.availHeight;

      if (distanceFromElement <= 200) {
        addFetch(element);
      }
    });
  });
});
